<?php

function loopz_woocommerce_hidden_forms() {
    ?>
    <form id="loopz_apply_remove_code" style="display: none;" method="POST">
        <input type="hidden" name="loopz_gift_card_code" id="loopz_gift_card_code" value="<?php echo esc_attr(loopz_cache::get_gift_card_code()) ?>">
        <input type="hidden" name="loopz_gift_card_nonce" id="loopz_gift_card_nonce" value="<?php echo esc_attr(wp_create_nonce('loopz_gift_card_nonce')) ?>">
    </form>
    <script>
        function loopz_set_code(code) {
            var form = document.getElementById("loopz_apply_remove_code");
            var input = document.getElementById("loopz_gift_card_code");
            input.value = code;
            form.submit();
        }
        function loopz_submit_code() {
            loopz_set_code(document.getElementById('giftcard_code').value);
        }
        function loopz_code_keypress(e) {
            var characterCode;

            if (e && e.which) {
                characterCode = e.which;
            }
            else {
                characterCode = event.keyCode;
            }

            if (characterCode == 13) {
                loopz_submit_code();
                return false;
            } else {
                return true;
            }
        }
    </script>
    <?php
}

function loopz_woocommerce_cart_coupon() {
    $incomingcode = null;
    $nonce = null;

    if (isset($_SERVER['REQUEST_METHOD']) && 'POST' == $_SERVER['REQUEST_METHOD'] && isset($_POST['loopz_gift_card_code']) && isset($_POST['loopz_gift_card_nonce']) ) {
        $nonce = sanitize_text_field(wp_unslash($_POST['loopz_gift_card_nonce']));
        $incomingcode = sanitize_text_field(wp_unslash($_POST['loopz_gift_card_code']));

        if ( empty($incomingcode) == false) {
            $incomingcode = str_replace(array("-", "_", " "), "", $incomingcode);
        }
    }

    $appliedcode = loopz_cache::get_gift_card_code();
    $balance = loopz_api::get_gift_card_balance();

    $initial_gc_apply_state = "inline-block";
    $initial_gc_form_state = "none";
    $message = "";

    if ( isset($appliedcode) && isset($nonce) && wp_verify_nonce($nonce, 'loopz_gift_card_nonce') && strlen($appliedcode) > 0 &&  $balance <= 0 ) {
        $appliedcode = "";
        $initial_gc_apply_state = "none";
        $initial_gc_form_state = "grid";

        if ( $balance <= 0 ) {
            $message = __( 'Gift card has no remaining balance', 'loopz-gift-cards' );
            $appliedcode = loopz_cache::set_gift_card_code( null );
        }
    }
    else if ( !empty($incomingcode) && empty($appliedcode) ) {
        $initial_gc_apply_state = "none";
        $initial_gc_form_state = "grid";
        $message =  __( 'Gift card not found', 'loopz-gift-cards' );
        $appliedcode = loopz_cache::set_gift_card_code( null );
    }

    $responsive_title = __( 'Gift card', 'loopz-gift-cards' );

    if ( !empty($appliedcode)) {
        $responsive_title = $responsive_title . " (" . $appliedcode . ")";
    }

    ?>
    <tr class="cart-subtotal loopz-cart-subtotal">
        <th class="loopz-cart-subtotal-th" <?php if(empty($appliedcode)): ?> colspan="2" <?php endif; ?> >
            <?php if ( loopz_preferences::get_woocommerce_test_mode() ): ?>
                [TEST]
            <?php endif; ?>
            <?php echo esc_html(__( 'Gift card', 'loopz-gift-cards' )) ?>

            <?php if ( !empty($appliedcode) ): ?>
                <div class="loopz-cart-subtotal-th-balance-container" style="font-weight: normal; font-size: small; font-weight: 300;">
                    <div class="loopz-cart-subtotal-th-balance-title woocommerce-Price-amount"><span style="text-transform: uppercase"><?php echo esc_html($appliedcode) ?></span></div>
                    <div class="loopz-cart-subtotal-th-balance-value woocommerce-Price-amount"><?php echo esc_html(__( 'Balance', 'loopz-gift-cards' )) ?>: <?php echo wp_kses(wc_price($balance), ['pre_user_description']) ?></div>
                </div>
            <?php endif; ?>
            <?php if ( empty($appliedcode) ): ?>
                <div id="loopz-apply-gc-form" class="loopz-cart-subtotal-td-form" style="display: <?php echo esc_attr($initial_gc_form_state) ?>; display: flex;">
                    <input class="loopz-cart-subtotal-td-form-input input-text" type="text" id="giftcard_code" style="flex-grow: 1; margin-right: 8px"
                           value="<?php echo esc_attr($incomingcode) ?>" placeholder="<?php echo esc_attr(__( 'Gift card code', 'loopz-gift-cards' )) ?>"
                           onkeypress="return loopz_code_keypress()"
                           style="width: 100%; margin: 8px; min-width: 110px">
                    <button class="loopz-cart-subtotal-td-form-button button wp-element-button" type="button" name="loopz_giftcard_button"
                            value="<?php echo esc_attr(__( 'Apply gift card', 'loopz-gift-cards' )) ?>" style="white-space: nowrap; margin: 0;"
                            onclick="loopz_submit_code()"><?php echo esc_html(__( 'Apply', 'loopz-gift-cards' )) ?></button>
                </div>
                <?php if ( empty($message) == false ): ?>
                    <ul class="woocommerce-error loopz-cart-subtotal-error" style="margin-top: 1rem" role="alert">
                        <li><?php echo esc_html($message) ?></li>
                    </ul>
                <?php endif; ?>
            <?php endif; ?>
        </th>
        <?php if ( !empty($appliedcode) ): ?>
            <td data-title="<?php echo esc_attr($responsive_title) ?>" class="loopz-cart-subtotal-td">
                <span class="woocommerce-Price-amount amount loopz-cart-subtotal-td-applied-balance" style="font-weight: normal;">
                    <?php echo wp_kses(wc_price(-1 * loopz_cache::$applied_gift_card_balance), ['pre_user_description']) ?> [<a href="#" onclick="loopz_set_code(''); return false;"><?php echo esc_html(__( 'Remove', 'loopz-gift-cards' )) ?></a>]
                </span>
            </td>
        <?php endif; ?>
    </tr>
    <?php
}
