<?php
/**
 * Functions to add the Send as a Gift button to a gift card product page managed by Loopz or to our of stock product pages.
 */

define( 'LOOPZ_META_DATA_KEY_SENDER_NAME', 'loopz_sender_name' );
define( 'LOOPZ_META_DATA_KEY_SENDER_EMAIL', 'loopz_sender_email' );
define( 'LOOPZ_META_DATA_KEY_RECIPIENT_NAME', 'loopz_recipient_name' );
define( 'LOOPZ_META_DATA_KEY_RECIPIENT_EMAIL', 'loopz_recipient_email' );
define( 'LOOPZ_META_DATA_KEY_SEND_TO_SENDER', 'loopz_send_to_sender' );
define( 'LOOPZ_META_DATA_KEY_DELIVERY', 'loopz_delivery' );
define( 'LOOPZ_META_DATA_KEY_DELIVERY_TIME', 'loopz_delivery_time' );
define( 'LOOPZ_META_DATA_KEY_DELIVERY_TIME_ISO', 'loopz_delivery_time_iso' );
define( 'LOOPZ_META_DATA_KEY_MESSAGE', 'loopz_message' );
define( 'LOOPZ_META_DATA_KEY_CARD_DESIGN_ID', 'loopz_card_design_id' );
define( 'LOOPZ_META_DATA_KEY_GIFT_AMOUNT', 'gift-amount' );


// Render send as a gift button hooks
add_filter( 'woocommerce_after_add_to_cart_button', 'loopz_gift_card_product_button_after_cart_button');
add_action( 'woocommerce_before_add_to_cart_button', 'loopz_gift_card_product_form_fields' );
add_action( 'woocommerce_add_cart_item_data', 'loopz_gift_card_product_process_meta_data', 10, 1 );
add_action( 'woocommerce_checkout_create_order_line_item', 'loopz_add_order_line_item_meta_data', 10, 4);
add_filter( 'woocommerce_get_item_data', 'loopz_render_cart_item_meta_data', 10, 2 );
add_filter('woocommerce_product_add_to_cart_text', 'loopz_gift_card_product_add_to_card_button_text', 10, 2);
add_filter('woocommerce_product_single_add_to_cart_text', 'loopz_gift_card_product_add_to_card_button_text', 10, 2);

// Add hooks for button group variation form
add_filter( 'woocommerce_dropdown_variation_attribute_options_html', 'loopz_replace_variation_dropdown_with_buttons', 10, 2 );
add_action( 'wp_enqueue_scripts', 'loopz_enqueue_button_group_assets' );
add_filter( 'woocommerce_reset_variations_link', '__return_empty_string' );

function loopz_add_order_line_item_meta_data($item, $cart_item_key, $values, $order) {
    // Transfer meta data from cart to order line item
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_SENDER_NAME);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_SENDER_EMAIL);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_RECIPIENT_NAME);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_RECIPIENT_EMAIL);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_SEND_TO_SENDER);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_DELIVERY);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_DELIVERY_TIME);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_DELIVERY_TIME_ISO);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_MESSAGE);
    add_order_line_item_meta_data($item, $values, LOOPZ_META_DATA_KEY_CARD_DESIGN_ID);
}

function add_order_line_item_meta_data(&$item, &$values, $meta_data_key) {
    if (isset($values[$meta_data_key])) {
        $item->add_meta_data(
            '_'.$meta_data_key,
            $values[$meta_data_key],
            true
        );
    }
}

function loopz_gift_card_product_add_to_card_button_text($text, $product) {
    $product_id = loopz_preferences::get_product_id();
    if(!isset($product_id) || $product_id != strval($product->get_id())) {
        return $text;
    }

    if ($product->get_id() == $product_id) {
        return __('Send as a Gift', 'loopz-gift-cards');
    }

    return $text;
}

function loopz_render_cart_item_meta_data( $item_data, $cart_item ) {
    $sender_details = '';
    $recipient_details = '';
    if (isset( $cart_item['loopz_sender_name'] ) ) {
        $sender_details = $cart_item['loopz_sender_name'];
        if(isset($cart_item['loopz_sender_email'])) {
            $sender_details .= ' - ' . $cart_item['loopz_sender_email'];
        }

    }

    if (isset( $cart_item['loopz_recipient_name'] ) ) {
        $recipient_details = $cart_item['loopz_recipient_name'];
        if(isset($cart_item['loopz_recipient_email'])) {
            $recipient_details .= ' - ' . $cart_item['loopz_recipient_email'];
        }
    }

    $send_to_sender = isset( $cart_item['loopz_send_to_sender'] ) &&  $cart_item['loopz_send_to_sender'] === 'true';

    if( $send_to_sender && !empty($sender_details)) {
        $item_data[] = array(
            'key'     => __( 'Recipient', 'loopz-gift-cards' ), // Label
            'value'   => $sender_details, // Raw value
            'display' => $sender_details, // Displayed value
        );
    } else {
        if(!empty($recipient_details)) {
            $item_data[] = array(
                'key'     => __( 'Recipient', 'loopz-gift-cards' ), // Label
                'value'   => $recipient_details, // Raw value
                'display' => $recipient_details, // Displayed value
            );
        }
        if(!empty($sender_details)) {
            $item_data[] = array(
                'key'     => __( 'Sender', 'loopz-gift-cards' ), // Label
                'value'   => $sender_details, // Raw value
                'display' => $sender_details, // Displayed value
            );
        }
    }

    $delivery = '';

    if (isset( $cart_item['loopz_delivery'] ) ) {
        if($cart_item['loopz_delivery'] === 'FUTURE') {
            $delivery = __( 'Scheduled for ', 'loopz-gift-cards' ) . $cart_item['loopz_delivery_time'];
        } else {
            $delivery = __( 'Instant', 'loopz-gift-cards' );
        }
    }

    if(!empty($delivery)) {
        $item_data[] = array(
            'key'     => __( 'Delivery', 'loopz-gift-cards' ), // Label
            'value'   => $delivery, // Raw value
            'display' => $delivery, // Displayed value
        );
    }

    if (isset( $cart_item['loopz_message'] ) ) {
        $item_data[] = array(
            'key'     => __( 'Message', 'loopz-gift-cards' ), // Label
            'value'   => $cart_item['loopz_message'], // Raw value
            'display' => $cart_item['loopz_message'], // Displayed value
        );
    }

    return $item_data;
}

function loopz_gift_card_product_process_meta_data( $cart_item_data ) {
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_CARD_DESIGN_ID);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_SENDER_NAME);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_SENDER_EMAIL);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_RECIPIENT_NAME);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_RECIPIENT_EMAIL);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_SEND_TO_SENDER);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_DELIVERY);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_DELIVERY_TIME);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_DELIVERY_TIME_ISO);
    add_cart_line_item_meta_data($cart_item_data, LOOPZ_META_DATA_KEY_MESSAGE, true);
    return $cart_item_data;
}

function add_cart_line_item_meta_data(&$cart_item_data, $meta_data_key, $is_multiline = false) {
    if(isset($_POST['loopz_gift_card_product_nonce'])) {
        $nonce = sanitize_text_field(wp_unslash($_POST['loopz_gift_card_product_nonce']));
        if (wp_verify_nonce($nonce, 'loopz-gift-card-product')) {
            if ( isset( $_POST[$meta_data_key] ) && !empty($_POST[$meta_data_key])) {
                $meta_data_value = $is_multiline
                    ? sanitize_textarea_field(wp_unslash($_POST[$meta_data_key]))
                    : sanitize_text_field(wp_unslash($_POST[$meta_data_key]));
                $cart_item_data[$meta_data_key] = $meta_data_value;
            }
        }
    }
}

function loopz_gift_card_product_form_fields() {
    if(!loopz_preferences::get_woocommerce_enabled()) {
        return;
    }

    global $product;
    if ( !is_a( $product, 'WC_Product' ) ) {
        // Do something with $product
        return;
    }

    $product_id = loopz_preferences::get_product_id();
    if(!isset($product_id) || $product_id != strval($product->get_id())) {
        return;
    }

    $nonce = wp_create_nonce('loopz-gift-card-product');

    echo '<input type="hidden" name="loopz_card_design_id" id="loopz_card_design_id" >';
    echo '<input type="hidden" name="loopz_recipient_name" id="loopz_recipient_name" >';
    echo '<input type="hidden" name="loopz_recipient_email" id="loopz_recipient_email" >';
    echo '<input type="hidden" name="loopz_send_to_sender" id="loopz_send_to_sender" >';
    echo '<input type="hidden" name="loopz_sender_name" id="loopz_sender_name" >';
    echo '<input type="hidden" name="loopz_sender_email" id="loopz_sender_email" >';
    echo '<input type="hidden" name="loopz_delivery" id="loopz_delivery" value="INSTANT">';
    echo '<input type="hidden" name="loopz_delivery_time" id="loopz_delivery_time" >';
    echo '<input type="hidden" name="loopz_delivery_time_iso" id="loopz_delivery_time_iso" >';
    echo '<input type="hidden" name="loopz_message" id="loopz_message" >';
    echo '<input type="hidden" name="loopz_gift_card_product_nonce" id="loopz_gift_card_product_nonce" value="' . esc_attr($nonce) .'" >';
}

function loopz_gift_card_product_button_after_cart_button_loop( $add_to_cart_html, $product, $args ){
    if(!loopz_preferences::get_woocommerce_enabled()) {
        return $add_to_cart_html;
    }

    $product_id = loopz_preferences::get_product_id();
    if(!isset($product_id) || $product_id != strval($product->get_id())) {
        return $add_to_cart_html;
    }

    $product_script_url = loopz_preferences::get_product_script_url();
    if(!isset($product_script_url)) {
        return $add_to_cart_html;
    }

    $variants = array();
    $variations = $product->get_children();
    foreach ( $variations as $variation_id ) {
        $variation = wc_get_product( $variation_id );

        $variants[] = array(
            'id' => $variation_id,
            'price' => convert_to_cents($variation->get_price()),
            'sku' => $variation->get_sku(),
            'variation' => $variation->get_attributes()
        );
    }

    wp_enqueue_script(
        'loopz-gift-button.js', // Handle
        $asset_path = plugins_url( '../build/loopz-gift-button.js', __FILE__ ), // Path to your JS file
        array(), // Dependencies (e.g., 'jquery' if needed)
        filemtime( plugin_dir_path( __FILE__ ) . '../build/loopz-gift-button.js' ),
        true // Load in footer
    );

    $locale = get_locale();
    wp_localize_script( 'loopz-gift-button.js', 'LoopzGiftButtonSettings', array(
        'locale' => $locale,
        'languageTag' => substr($locale, 0, strpos($locale, '_')),
        'productId' => $product_id,
        'productHandle' => $product->get_slug(),
        'programId' => loopz_preferences::get_program_id(),
        'checkoutHost' => LOOPZ_CHECKOUT_HOST,
        'variants' => $variants,
        'addToCartUrl' => admin_url( 'admin-ajax.php' ),
        'addToCartAction' => 'loopz_add_gift_card_to_cart',
        'addToCartNonce' => wp_create_nonce('loopz_gift_card_add_to_cart'),
        'addToCartAjaxEnabled' => get_option('woocommerce_enable_ajax_add_to_cart')
    ) );

    wp_set_script_translations('loopz-gift-button.js', 'loopz-gift-cards');

    return $add_to_cart_html;
}

function loopz_gift_card_product_button_after_cart_button(){
    if(!loopz_preferences::get_woocommerce_enabled()) {
        return;
    }

    global $product;
    if ( !is_a( $product, 'WC_Product' ) ) {
        // Do something with $product
        return;
    }

    $product_id = loopz_preferences::get_product_id();
    if(!isset($product_id) || $product_id != strval($product->get_id())) {
        return;
    }

    $product_script_url = loopz_preferences::get_product_script_url();
    if(!isset($product_script_url)) {
        return;
    }

    $variants = array();
    $variations = $product->get_children();
    foreach ( $variations as $variation_id ) {
        $variation = wc_get_product( $variation_id );

        $variants[] = array(
            'id' => $variation_id,
            'price' => convert_to_cents($variation->get_price()),
            'sku' => $variation->get_sku(),
            'variation' => $variation->get_attributes()
        );
    }

    wp_enqueue_script(
        'loopz-gift-button.js', // Handle
        $asset_path = plugins_url( '../build/loopz-gift-button.js', __FILE__ ), // Path to your JS file
        array('jquery'), // Dependencies (e.g., 'jquery' if needed)
        filemtime( plugin_dir_path( __FILE__ ) . '../build/loopz-gift-button.js' ),
        true // Load in footer
    );

    $locale = get_locale();
    wp_localize_script( 'loopz-gift-button.js', 'LoopzGiftButtonSettings', array(
        'locale' => $locale,
        'languageTag' => substr($locale, 0, strpos($locale, '_')),
        'productId' => $product_id,
        'productHandle' => $product->get_slug(),
        'programId' => loopz_preferences::get_program_id(),
        'checkoutHost' => LOOPZ_CHECKOUT_HOST,
        'variants' => $variants,
        'addToCartUrl' => admin_url( 'admin-ajax.php' ),
        'addToCartAction' => 'loopz_add_gift_card_to_cart',
        'addToCartNonce' => wp_create_nonce('loopz_gift_card_add_to_cart'),
        'addToCartAjaxEnabled' => get_option('woocommerce_enable_ajax_add_to_cart')
    ) );

    wp_set_script_translations('loopz-gift-button.js', 'loopz-gift-cards');

}

/**
 * Replace WooCommerce variation dropdown with button groups for gift card products
 */
function loopz_replace_variation_dropdown_with_buttons( $html, $args ) {
    // Only apply to gift card products
    global $product;
    if ( !is_a( $product, 'WC_Product' ) ) {
        return $html;
    }

    $product_id = loopz_preferences::get_product_id();
    if(!isset($product_id) || $product_id != strval($product->get_id())) {
        return $html;
    }

    // Get the attribute name and options
    $attribute_name = $args['attribute'];
    $options = $args['options'];
    $product_obj = $args['product'];
    $attribute = $args['attribute'];
    $name = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title( $attribute );
    $id = $args['id'] ? $args['id'] : sanitize_title( $attribute );
    $class = $args['class'];
    $show_option_none = $args['show_option_none'] ? true : false;
    $show_option_none_text = $args['show_option_none'] ? $args['show_option_none'] : __( 'Choose an option', 'loopz-gift-cards' );

    if ( empty( $options ) && ! empty( $product_obj ) && ! empty( $attribute ) ) {
        $attributes = $product_obj->get_variation_attributes();
        $options = $attributes[ $attribute ];
    }

    // Generate button group HTML
    $button_group_html = '<div class="loopz-variation-button-group" data-attribute="' . esc_attr( $attribute ) . '">';
    
    if ( $show_option_none && empty( $options ) ) {
        $button_group_html .= '<p class="loopz-no-options">' . esc_html( $show_option_none_text ) . '</p>';
    } else {
        $button_group_html .= '<div class="loopz-button-group-wrapper">';
        
        foreach ( $options as $option ) {
            $selected = sanitize_title( $option ) === $args['selected'] ? 'selected' : '';
            $button_group_html .= sprintf(
                '<button type="button" class="loopz-variation-button %s" data-value="%s" data-attribute="%s">%s</button>',
                esc_attr( $selected ),
                esc_attr( $option ),
                esc_attr( $attribute ),
                esc_html( $option )
            );
        }
        
        $button_group_html .= '</div>';
    }
    
    $button_group_html .= '</div>';

    // Add hidden select for WooCommerce functionality
    $hidden_select = sprintf(
        '<select name="%s" id="%s" class="%s" style="display: none;" %s>',
        esc_attr( $name ),
        esc_attr( $id ),
        esc_attr( $class ),
        $args['required'] ? 'required' : ''
    );

    if ( $show_option_none ) {
        $hidden_select .= '<option value="">' . esc_html( $show_option_none_text ) . '</option>';
    }

    foreach ( $options as $option ) {
        $selected = $option === $args['selected'] ? 'selected' : '';
        $hidden_select .= sprintf(
            '<option value="%s" %s>%s</option>',
            esc_attr( $option  ),
            $selected,
            esc_html( $option )
        );
    }

    $hidden_select .= '</select>';

    return $button_group_html . $hidden_select;
}

/**
 * Enqueue assets for button group variation form
 */
function loopz_enqueue_button_group_assets() {
    // Only enqueue on gift card product pages
    global $product;
    if ( !is_a( $product, 'WC_Product' ) ) {
        return;
    }

    $product_id = loopz_preferences::get_product_id();
    if(!isset($product_id) || $product_id != strval($product->get_id())) {
        return;
    }

    wp_enqueue_style(
        'loopz-button-group-styles',
        plugins_url( '../assets/css/button-group.css', __FILE__ ),
        array(),
        filemtime( plugin_dir_path( __FILE__ ) . '../assets/css/button-group.css' )
    );

    wp_enqueue_script(
        'loopz-button-group-js',
        plugins_url( '../assets/js/button-group.js', __FILE__ ),
        array('jquery'),
        filemtime( plugin_dir_path( __FILE__ ) . '../assets/js/button-group.js' ),
        true
    );

    wp_set_script_translations('loopz-button-group-js', 'loopz-gift-cards');

}