<?php

class loopz_cache
{
    // Cache API gift card get API result per web request
    public static $giftcard = null;

    // Cache some cart totals
    public static $applied_gift_card_balance = 0;

    public static function get_gift_card_code()
    {
        if (WC()->session) {
            return WC()->session->get(LOOPZ_SESSION_KEY);
        }
        return null;
    }

    public static function set_gift_card_code($code)
    {
        if (WC()->session) {
            if (empty($code) || $code == null) {
                WC()->session->__unset(LOOPZ_SESSION_KEY);
                loopz_cache::$giftcard = null;
            } else {
                if (loopz_api::get_gift_card($code) != null) {
                    WC()->session->set(LOOPZ_SESSION_KEY, $code);
                }
            }
        }
    }

    public static function clear()
    {
        WC()->session->__unset(LOOPZ_SESSION_KEY);
        WC()->session->__unset(LOOPZ_ORDER_META_REQUESTED_BALANCE_KEY);
        loopz_cache::$giftcard = null;
        loopz_cache::$applied_gift_card_balance = 0;
    }
}
