<?php
/**
 * Class Blocks/Extend_Store_Endpoint file.
 *
 * @package Loopz\Blocks
 */

namespace Loopz\Checkout_Blocks;

use Automattic\WooCommerce\StoreApi\Schemas\ExtendSchema;
use Automattic\WooCommerce\StoreApi\Schemas\V1\CheckoutSchema;
use Automattic\WooCommerce\StoreApi\StoreApi;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class for extending the Store API endpoint for custom Loopz data in checkout.
 *
 * @package Loopz\Checkout_Blocks
 */
class Extend_Store_Endpoint {
	/**
	 * Stores Rest Extending instance.
	 *
	 * @var ExtendSchema
	 */
	private static $extend;

	/**
	 * Plugin Identifier, unique to each plugin.
	 *
	 * @var string
	 */
	const IDENTIFIER = 'loopz';

	/**
	 * Bootstraps the class and hooks required data.
	 */
	public static function init() {
		add_action( 'init', function () {
			self::$extend = StoreApi::container()->get( ExtendSchema::class );
			self::extend_store();
		} );

	}

	/**
	 * Registers the actual data into the Checkout endpoint.
	 */
	public static function extend_store() {
		if ( is_callable( array( self::$extend, 'register_endpoint_data' ) ) ) {
			self::$extend->register_endpoint_data(
				array(
					'endpoint'        => CheckoutSchema::IDENTIFIER,
					'namespace'       => self::IDENTIFIER,
					'schema_callback' => [ __CLASS__, 'extend_checkout_schema' ],
					'schema_type'     => ARRAY_A,
				)
			);
		}
	}

	/**
	 * Defines the schema for Loopz delivery data in Checkout.
	 *
	 * @return array Schema structure.
	 */
	public static function extend_checkout_schema() {
		return array(
			'giftCardCode' => array(
				'description' => 'Loopz gift card code',
				'context'     => array( 'view', 'edit' ),
				'readonly'    => false,
				'default'     => ''
			),
		);

	}

}
