/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./blocks/js/loopz-gift-card/block.js":
/*!********************************************!*\
  !*** ./blocks/js/loopz-gift-card/block.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LoopzGiftCardBlock: () => (/* binding */ LoopzGiftCardBlock)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @woocommerce/blocks-components */ "@woocommerce/blocks-components");
/* harmony import */ var _woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _woocommerce_settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @woocommerce/settings */ "@woocommerce/settings");
/* harmony import */ var _woocommerce_settings__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_settings__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);







const localizedStrings = loopzGiftCardData.localizedStrings;

/**
 * The LoopzGiftCardBlock component allows users to apply a gift card code.
 */
const LoopzGiftCardBlock = () => {
  const [isExpanded, setIsExpanded] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [giftCardCode, setGiftCardCode] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const [giftCardCurrency, setGiftCardCurrency] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const [isApplying, setIsApplying] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [giftCardApplied, setGiftCardApplied] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [giftCardValue, setGiftCardValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const storeCurrency = (0,_woocommerce_settings__WEBPACK_IMPORTED_MODULE_5__.getSetting)('currency', {});
  const currencySymbol = storeCurrency.symbol; // e.g., "$"

  // Access global data passed from PHP
  const loopzGiftCardData = window.loopzGiftCardData || {};

  // Define the validation store key
  const VALIDATION_STORE_KEY = 'wc/store/validation';

  // Get dispatch functions for the validation store
  const {
    setValidationErrors,
    clearValidationErrors
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(VALIDATION_STORE_KEY);

  // Get validation errors from the validation store
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    const store = select(VALIDATION_STORE_KEY);
    return store.getValidationError('loopz-gift-card-error'); // Unique error ID
  }, []);

  /**
   * Fetch applied gift card info on component mount.
   */
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setIsLoading(true);
    const formData = new URLSearchParams();
    formData.append('action', 'loopz_apply_gift_card'); // Using the same AJAX action to fetch applied gift card
    formData.append('nonce', loopzGiftCardData.nonce);
    // No gift_card_code parameter here

    fetch(loopzGiftCardData.ajax_url, {
      method: 'POST',
      body: formData,
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      timeout: 5000
    }).then(response => response.json()).then(responseBody => {
      if (responseBody.success && responseBody.data.gift_card_code) {
        setGiftCardApplied(true);
        setGiftCardCode(responseBody.data.gift_card_code);
        setGiftCardValue(responseBody.data.gift_card_value);
        setGiftCardCurrency(responseBody.data.gift_card_currency);
        // Clear any existing validation errors
        clearValidationErrors(['loopz-gift-card-error']);
      }
    }).catch(errorResponse => {
      setValidationErrors({
        'loopz-gift-card-error': {
          message: localizedStrings.gift_card_not_found,
          hidden: false
        }
      });
    }).finally(() => {
      setIsLoading(false);
    });
  }, [clearValidationErrors, loopzGiftCardData.nonce, loopzGiftCardData.ajax_url]);

  /**
   * Handle applying the gift card.
   */
  const onApplyGiftCard = async event => {
    event.preventDefault();

    // Clear previous validation errors
    clearValidationErrors(['loopz-gift-card-error']);

    // Validate input
    if (!giftCardCode.trim()) {
      setValidationErrors({
        'loopz-gift-card-error': {
          message: localizedStrings.please_enter_gift_card_code,
          hidden: false
        }
      });
      return;
    }
    setIsApplying(true);
    const formData = new URLSearchParams();
    formData.append('action', 'loopz_apply_gift_card');
    formData.append('nonce', loopzGiftCardData.nonce);
    formData.append('gift_card_code', giftCardCode.trim());
    fetch(loopzGiftCardData.ajax_url, {
      method: 'POST',
      body: formData,
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      timeout: 10000
    }).then(response => response.json()).then(responseBody => {
      if (responseBody.success) {
        const data = responseBody.data;
        setGiftCardApplied(true);
        setGiftCardValue(data.gift_card_value);
        setGiftCardCurrency(data.gift_card_currency);
        setIsExpanded(false);

        // Clear validation errors on success
        clearValidationErrors(['loopz-gift-card-error']);

        // Update the cart total using the Store API
        try {
          const {
            extensionCartUpdate
          } = window.wc.blocksCheckout || {};
          if (typeof extensionCartUpdate === 'function') {
            extensionCartUpdate({
              namespace: 'loopz',
              data: {
                action: 'update_gift_card_discount',
                price: parseFloat(data.gift_card_value),
                code: data.gift_card_code
              }
            });
          }
        } catch {
          // If updating the cart fails, default to "Gift card not found"
          setValidationErrors({
            'loopz-gift-card-error': {
              message: localizedStrings.gift_card_not_found,
              hidden: false
            }
          });
        }
      } else if (!responseBody.success) {
        const backendErrorMessage = responseBody.data?.message || localizedStrings.gift_card_not_found;
        setValidationErrors({
          'loopz-gift-card-error': {
            message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)(backendErrorMessage, 'loopz-gift-cards'),
            hidden: false
          }
        });
      }
    }).catch(errorResponse => {
      const backendErrorMessage = errorResponse.response?.data?.data?.message || localizedStrings.gift_card_not_found;
      setValidationErrors({
        'loopz-gift-card-error': {
          message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)(backendErrorMessage, 'loopz-gift-cards'),
          hidden: false
        }
      });
    }).finally(() => {
      setIsApplying(false);
    });
  };

  /**
   * Handle removing the gift card.
   */
  const onRemoveGiftCard = async () => {
    setIsLoading(true);

    // Clear previous validation errors
    clearValidationErrors(['loopz-gift-card-error']);
    try {
      // Update the cart to remove the gift card discount
      const {
        extensionCartUpdate
      } = window.wc.blocksCheckout || {};
      if (typeof extensionCartUpdate === 'function') {
        await extensionCartUpdate({
          namespace: 'loopz',
          data: {
            action: 'remove_gift_card_discount'
          }
        });
      }
      setGiftCardApplied(false);
      setGiftCardValue(0);
      setGiftCardCode('');
      setIsExpanded(false);
    } catch {
      // If removing fails, default to "Gift card not found"
      setValidationErrors({
        'loopz-gift-card-error': {
          message: localizedStrings.gift_card_not_found,
          hidden: false
        }
      });
    } finally {
      setIsLoading(false);
    }
  };
  function handleGiftCodeInputChange(value) {
    setGiftCardCode(value);
    clearValidationErrors(['loopz-gift-card-error']);
  }
  function getAppliedGiftCardLabel() {
    return '•••• ' + giftCardCode.substring(giftCardCode.length - 4);
  }
  if (!loopzGiftCardData.redemptionEnabled) {
    return;
  }
  if (isLoading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Spinner, {});
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "wp-block-woocommerce-checkout-order-summary-coupon-form-block wc-block-components-totals-wrapper",
    children: [giftCardApplied && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
      title: localizedStrings.applied_gift_card,
      className: "wc-block-components-totals-coupon wc-block-components-panel",
      initialOpen: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__.RemovableChip, {
        text: getAppliedGiftCardLabel(),
        screenReaderText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(localizedStrings.gift_card_with_code, giftCardCode),
        disabled: isLoading,
        onRemove: onRemoveGiftCard,
        radius: "large",
        ariaLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(localizedStrings.gift_card_quoted, giftCardCode)
      }, 'gift-card-' + giftCardCode)
    }), !giftCardApplied && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
      title: localizedStrings.add_a_gift_card,
      className: "wc-block-components-totals-coupon wc-block-components-panel",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("form", {
        onSubmit: onApplyGiftCard,
        className: "wc-block-components-totals-coupon__form",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__.ValidatedTextInput, {
          id: 'loopz-gift-card-input',
          type: "text",
          label: localizedStrings.enter_gift_code,
          ariaLabel: localizedStrings.enter_gift_code,
          value: giftCardCode,
          onChange: handleGiftCodeInputChange,
          focusOnMount: true,
          className: "wc-block-components-text-input wc-block-components-totals-coupon__input"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
          type: 'submit',
          variant: 'contained',
          disabled: isApplying || !giftCardCode.trim(),
          className: 'wc-block-components-button wp-element-button wc-block-components-totals-coupon__button contained',
          children: localizedStrings.apply
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_woocommerce_blocks_components__WEBPACK_IMPORTED_MODULE_3__.ValidationInputError, {
        errorMessage: validationError && validationError?.message ? validationError.message : null
      })]
    })]
  });
};

/***/ }),

/***/ "./blocks/js/loopz-gift-card/block.json":
/*!**********************************************!*\
  !*** ./blocks/js/loopz-gift-card/block.json ***!
  \**********************************************/
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"apiVersion":2,"name":"loopz/gift-card","version":"2.0.0","title":"Gift Card","category":"woocommerce","description":"Shows the apply gift card form.","supports":{"html":false,"align":false,"multiple":false,"reusable":false},"parent":["woocommerce/checkout-order-summary-block","woocommerce/cart-order-summary-block","woocommerce/mini-cart"],"attributes":{"lock":{"type":"object","default":{"remove":true,"move":true}},"giftCardCode":{"type":"string","default":""}},"textdomain":"gift-card","editorStyle":"file:../style-loopz-gift-card.css","style":"file:./style-index.css"}');

/***/ }),

/***/ "./blocks/js/loopz-gift-card/frontend.js":
/*!***********************************************!*\
  !*** ./blocks/js/loopz-gift-card/frontend.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @woocommerce/blocks-checkout */ "@woocommerce/blocks-checkout");
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _block__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./block */ "./blocks/js/loopz-gift-card/block.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./block.json */ "./blocks/js/loopz-gift-card/block.json");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.scss */ "./blocks/js/loopz-gift-card/style.scss");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */



if (window.loopzGiftCardData?.redemptionEnabled === 'true') {
  (0,_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__.registerCheckoutBlock)({
    metadata: _block_json__WEBPACK_IMPORTED_MODULE_2__,
    component: _block__WEBPACK_IMPORTED_MODULE_1__.LoopzGiftCardBlock
  });
}

/***/ }),

/***/ "./blocks/js/loopz-gift-card/style.scss":
/*!**********************************************!*\
  !*** ./blocks/js/loopz-gift-card/style.scss ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "@woocommerce/blocks-checkout":
/*!****************************************!*\
  !*** external ["wc","blocksCheckout"] ***!
  \****************************************/
/***/ ((module) => {

module.exports = window["wc"]["blocksCheckout"];

/***/ }),

/***/ "@woocommerce/blocks-components":
/*!******************************************!*\
  !*** external ["wc","blocksComponents"] ***!
  \******************************************/
/***/ ((module) => {

module.exports = window["wc"]["blocksComponents"];

/***/ }),

/***/ "@woocommerce/settings":
/*!************************************!*\
  !*** external ["wc","wcSettings"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wc"]["wcSettings"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"loopz-gift-card-frontend": 0,
/******/ 			"./style-loopz-gift-card-frontend": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunkloopz_gift_cards"] = globalThis["webpackChunkloopz_gift_cards"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["./style-loopz-gift-card-frontend"], () => (__webpack_require__("./blocks/js/loopz-gift-card/frontend.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=loopz-gift-card-frontend.js.map