/**
 * External dependencies
 */
import {__, sprintf} from '@wordpress/i18n';
import {useState} from '@wordpress/element';
import {Button, Panel, ValidatedTextInput, ValidationInputError} from '@woocommerce/blocks-components';
import {useBlockProps} from '@wordpress/block-editor';

const localizedStrings = loopzGiftCardData.localizedStrings;

export const Edit = () => {
    const blockProps = useBlockProps();

    // State variables
    const [isExpanded, setIsExpanded] = useState(true); // Default to true to show the form
    const [giftCardCode, setGiftCardCode] = useState('');
    const [isApplying, setIsApplying] = useState(false);

    // Dummy function for onApplyGiftCard
    const onApplyGiftCard = (event) => {
        event.preventDefault();
        // No functionality in editor; this is just a placeholder
    };

    function handleGiftCodeInputChange(value) {
        setGiftCardCode(value);
    }

    return (<div {...blockProps}>
        <div
            className="wp-block-woocommerce-checkout-order-summary-coupon-form-block wc-block-components-totals-wrapper">
            <Panel
                title={localizedStrings.add_a_gift_card}
                className="wc-block-components-totals-coupon wc-block-components-panel"
            >
                <form
                    onSubmit={onApplyGiftCard}
                    className="wc-block-components-totals-coupon__form"
                >
                    <ValidatedTextInput
                        id={'loopz-gift-card-input'}
                        type="text"
                        label={localizedStrings.enter_gift_code}
                        ariaLabel={localizedStrings.enter_gift_code}
                        value={giftCardCode}
                        onChange={handleGiftCodeInputChange}
                        focusOnMount
                        className="wc-block-components-text-input wc-block-components-totals-coupon__input"
                    />

                    <Button

                        type={'submit'}
                        variant={'contained'}
                        disabled={isApplying || !giftCardCode.trim()}
                        className={'wc-block-components-button wp-element-button wc-block-components-totals-coupon__button contained'}

                    >
                        {localizedStrings.apply}
                    </Button>
                </form>
            </Panel>
        </div>
        </div>
        );
        };

        export const Save = () => {
        return null;
    };
