window.LoopzGiftCardButton = window.LoopzGiftCardButton || {
  BUTTON_ID: "loopz-send-as-gift-button",
  PRODUCT_ID: LoopzGiftButtonSettings.productId,
  PRODUCT_HANDLE: LoopzGiftButtonSettings.productHandle,
  PROGRAM_ID: LoopzGiftButtonSettings.programId,
  EMBED_ON_OUT_OF_STOCK: true,
  OPEN_CART_PAGE: false,
  OPEN_POPUP_ON_VISIT: false,
  CHECKOUT_URL: LoopzGiftButtonSettings.checkoutHost + "/gift-card/" + LoopzGiftButtonSettings.programId + "?mode=shopify&locale=" + (LoopzGiftButtonSettings.locale ? LoopzGiftButtonSettings.locale : 'en-US'),
  DEFAULT_BUTTON_SELECTORS: ["button[name='add']", "input[name='add']", ".ProductForm__AddToCart", "input[id='AddToCart']", "button[id='shopify_add_to_cart']"],
  DEFAULT_AMOUNT_SELECTORS: ["select[id='SingleOptionSelector-0']"],
  SELECTORS: [],
  GET_VARIANT_JS: null,
  UPDATE_CART_JS: null,
  BUTTON_STYLE: null,
  LOCALIZED_STRINGS: {},
  VARIANT_OPTION_CARD_DESIGNS: {},
  POPUP_BORDER_RADIUS: 24,
  POPUP_WIDTH: 1050,
  POPUP_HEIGHT: 750,
  ADD_TO_CART_URL: LoopzGiftButtonSettings.addToCartUrl,
  initialized: false,
  popup: null,
  product: null,
  variants: LoopzGiftButtonSettings.variants,
  selectedVariant: null,
  locale: LoopzGiftButtonSettings.languageTag,
  themeName: null,
  supportedLocales: ['en', 'fr', 'de', 'it', 'es'],
  localizedStrings: {
    'en': {
      ADD_TO_CART: 'Add to Cart',
      SEND_AS_GIFT: 'Send as a Gift',
      SEND_GIFT_CARD_INSTEAD: 'Send a gift card instead',
      TO: 'Recipient',
      FROM: 'Sender',
      DELIVERY: 'Delivery',
      DELIVERY_INSTANT: 'Instant',
      DELIVERY_SCHEDULED: 'Scheduled for'
    },
    'fr': {
      ADD_TO_CART: 'Ajouter au Panier',
      SEND_AS_GIFT: 'Envoyer en cadeau',
      SEND_GIFT_CARD_INSTEAD: 'Envoyez plutôt une carte-cadeau',
      TO: 'Destinataire',
      FROM: 'Expéditeur',
      DELIVERY: 'Delivery',
      DELIVERY_INSTANT: 'Instant',
      DELIVERY_SCHEDULED: 'Prévu pour'
    },
    'de': {
      ADD_TO_CART: 'in den Warenkorb legen',
      SEND_AS_GIFT: 'Als Geschenk versenden',
      SEND_GIFT_CARD_INSTEAD: 'Senden Sie stattdessen eine Geschenkkarte',
      TO: 'Empfänger',
      FROM: 'Absender',
      DELIVERY: 'Lieferung',
      DELIVERY_INSTANT: 'Sofortig',
      DELIVERY_SCHEDULED: 'Eingetragen für'
    },
    'it': {
      ADD_TO_CART: 'Aggiungi al carrello',
      SEND_AS_GIFT: 'Invia come regalo',
      SEND_GIFT_CARD_INSTEAD: 'Invia invece una carta regalo',
      TO: 'Destinatario',
      FROM: 'Mittente',
      DELIVERY: 'Consegna',
      DELIVERY_INSTANT: 'Immediato',
      DELIVERY_SCHEDULED: 'Pianificato per'
    },
    'es': {
      ADD_TO_CART: 'Añadir al carrito',
      SEND_AS_GIFT: 'Enviar como regalo',
      SEND_GIFT_CARD_INSTEAD: 'Enviar una tarjeta de regalo en su lugar',
      TO: 'Destinatario',
      FROM: 'Remitente',
      DELIVERY: 'Entrega',
      DELIVERY_INSTANT: 'Instantáneo',
      DELIVERY_SCHEDULED: 'Programado para'
    },
  },
  localizedMonthNames: {
    'en': ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    'fr': ['janv', 'févr', 'mars', 'avril', 'mai', 'juin', 'juil', 'août', 'sep', 'oct', 'nov', 'déc'],
    'de': ['Jän', 'Feb', 'März', 'Apr', 'Mai', 'Juni', 'Juli', 'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
    'it': ['genn', 'febbr', 'mar', 'apr', 'magg', 'giugno', 'luglio', 'ag', 'sett', 'ott', 'nov', 'dic'],
    'es': ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic']
  },
  getLocalizedString: function(locale, name) {
    if (this.LOCALIZED_STRINGS && this.LOCALIZED_STRINGS[locale] && this.LOCALIZED_STRINGS[locale][name]) {
      return this.LOCALIZED_STRINGS[locale][name];
    }
    if(this.localizedStrings[locale] && this.localizedStrings[locale][name]) {
      return this.localizedStrings[locale][name];
    }
    return '';
  },

  init: function() {
    if(this.initialized) {
      return;
    }
    this.initialized = true;

    let button = document.querySelector(".variations_form button[type=submit]");
    if(!button) {
      return;
    }

    const updateCartUIScript = document.getElementById("loopz-update-cart-ui-js");
    if(updateCartUIScript) {
      let updateCartUIJs = updateCartUIScript.textContent.trim();
      if(updateCartUIJs.charAt(0) === "'" && updateCartUIJs.charAt(updateCartUIJs.length-1) === "'") {
        updateCartUIJs = updateCartUIJs.substring(1, updateCartUIJs.length - 1);
      }
      this.UPDATE_CART_JS = updateCartUIJs;
    }

    const getVariantScript = document.getElementById("loopz-get-variant-js");
    if(getVariantScript) {
      let getVariantJs = getVariantScript.textContent.trim();
      if(getVariantJs.charAt(0) === "'" && getVariantJs.charAt(getVariantJs.length-1) === "'") {
        getVariantJs = getVariantJs.substring(1, getVariantJs.length - 1);
      }
      this.GET_VARIANT_JS = getVariantJs;
    }

    const that = this;

    button.addEventListener('click', function(e) {
      e.preventDefault();
      e.stopPropagation();
      that.showPopup();
    });

    // Listen to variant changes on the product page
    jQuery(document).ready(function($) {
      // Target the variation form
      var $form = $('.variations_form');

      // Listen for the 'found_variation' event
      $form.on('found_variation', function(event, variation) {
        var isAvailable = variation.is_purchasable && variation.is_in_stock; // Availability

        if (variation && isAvailable) {
          that.selectedVariant = variation;
        } else {
          that.selectedVariant = null;
        }
      });

      // Optional: Handle when no valid variation is selected
      $form.on('reset_data', function() {
        that.selectedVariant = null;
      });
    });

    // fetch the product and verify it's the correct product ID
    // fetch(window.Shopify.routes.root + "products/" + that.PRODUCT_HANDLE + ".js")
    //     .then(response => {
    //       if(response.ok) {
    //         response.json().then((product) => {
    //           if (product.id !== parseInt(that.PRODUCT_ID)) {
    //             // Check if the non gift card product is unavailable and if the out of stock embed option is enabled
    //             if (!product.available && that.EMBED_ON_OUT_OF_STOCK) {
    //               buttonLabel = that.getLocalizedString(that.locale, 'SEND_GIFT_CARD_INSTEAD');
    //               fetch("/products/" + that.PRODUCT_HANDLE + ".js")
    //                   .then(response => response.json())
    //                   .then(function(giftCardProduct) {
    //                     that.product = giftCardProduct;
    //                     button.removeAttribute("disabled");
    //                   });
    //             } else {
    //               return;
    //             }
    //           } else {
    //             that.product = product;
    //             button.removeAttribute("disabled");
    //             that.showPopupIfOpenByDefault();
    //           }
    //         });
    //       }
    //     });
  },
  showPopupIfOpenByDefault: function() {
    if(this.OPEN_POPUP_ON_VISIT) {
      this.showPopup();
      return;
    }
    let queryParams = new URLSearchParams(document.location.search.substring(1));
    if(queryParams.has('c')) {
      let customQueryParams = new URLSearchParams(atob(queryParams.get('c')));
      if(customQueryParams.has('o') && customQueryParams.get('o') === 'true') {
        this.showPopup();
      }
    }
  },

  buildCheckoutUrl: function(){
    let url = this.CHECKOUT_URL;
    let searchParams = new URLSearchParams(document.location.search);
    if (searchParams.has('c')) {
      url += '&c=' + searchParams.get('c');
    }
    return url;
  },

  drawPopup: function() {
      if (this.popup) {
        return this.popup;
      }
      var overlayEl = document.createElement('div');
      overlayEl.style.cssText = 'width: 100%; height:100%; position:absolute; left: 0; top: 0; z-index: 9999';

      var maskEl = document.createElement('div');
      maskEl.style.cssText = 'background-color: black; width: 100%; height:100%; position:absolute; left: 0; top: 0; opacity: 0.5; z-index: -1';
      overlayEl.appendChild(maskEl);

      var popupEl = document.createElement('div');
      var alignCss = 'top: 50%; left: 50%; transform: translateX(-50%) translateY(-50%);';

      popupEl.style.cssText = 'position: fixed; ' + alignCss + ' display: block; width: 100%; max-width: ' + this.POPUP_WIDTH + 'px; height: 100%; max-height: ' + this.POPUP_HEIGHT + 'px; box-shadow: 0px 0px 32px black; border-radius:' + this.POPUP_BORDER_RADIUS + 'px';
      overlayEl.appendChild(popupEl);

      var iframeEl = document.createElement('iframe');

      iframeEl.src = this.buildCheckoutUrl();
      iframeEl.loading = 'lazy';
      iframeEl.width = '100%';
      iframeEl.height = '100%';

      iframeEl.style.cssText = 'display: block; width: 100%; max-width: ' + this.POPUP_WIDTH + 'px; height: 100%; max-height: ' + this.POPUP_HEIGHT + 'px; background-color: white; border-width: 0px; border-radius: ' + this.POPUP_BORDER_RADIUS + 'px';

      popupEl.appendChild(iframeEl);

      var closeEl = document.createElement('div');
      closeEl.style.cssText = 'position: absolute; right:1px; top:2px; cursor: pointer';
      closeEl.innerHTML = '<svg style="width:48px;height:48px" viewBox="0 0 24 24">\n' +
        '    <path style="fill: #757575" d="M12,2C17.53,2 22,6.47 22,12C22,17.53 17.53,22 12,22C6.47,22 2,17.53 2,12C2,6.47 6.47,2 12,2M15.59,7L12,10.59L8.41,7L7,8.41L10.59,12L7,15.59L8.41,17L12,13.41L15.59,17L17,15.59L13.41,12L17,8.41L15.59,7Z" />\n' +
        '</svg>';
      popupEl.appendChild(closeEl);

      var that = this;
      closeEl.onclick = function() {
        that.closePopup();
      };
      closeEl.onmouseenter = function() {
        var path = this.getElementsByTagName('path')[0];
        path.style.fill = '#D32F2F';
      };
      closeEl.onmouseleave = function() {
        var path = this.getElementsByTagName('path')[0];
        path.style.fill = '#757575';
      };

      this.popup = {
        overlayEl: overlayEl,
        iframeEl: iframeEl,
        checkoutUrl: this.CHECKOUT_URL,
        resetOnOpen: true
      }

      this.initPopupMessageEventListener();
    },

  showPopup: function() {
    var that = this;

    if (this.popup === null) {
      this.drawPopup();
    }
    if (this.popup.resetOnOpen && this.popup.iframeEl.contentWindow) {
      this.popup.iframeEl.contentWindow.postMessage('reset', '*');
    }
    this.popup.overlayEl.hidden = false;
    if(this.popup.overlayEl.parentElement == null) {
      document.body.appendChild(this.popup.overlayEl);
    }
    document.body.scrollTop = document.documentElement.scrollTop = 0;
    document.onkeydown = function(evt) {
      evt = evt || window.event;
      var isEscape = false;
      if ("key" in evt) {
        isEscape = (evt.key == "Escape" || evt.key == "Esc");
      } else {
        isEscape = (evt.keyCode == 27);
      }
      if (isEscape) {
        that.closePopup();
        evt.stopPropagation();
        evt.preventDefault();
        return false;
      }
    };

    this.initCheckout();
  },

  initPopupMessageEventListener: function() {
    const that = this;
    window.addEventListener("message", async function(event) {
      if(event.data === 'close') {
        that.closePopup();
      }
      if(event.data && event.data.shopifyAddToCart) {
        let giftCardDetails = event.data.shopifyAddToCart;
        let cardDesignOptionValue = giftCardDetails.cardDesignId ? that.VARIANT_OPTION_CARD_DESIGNS[giftCardDetails.cardDesignId] : null;
        let variant = null;
        if (cardDesignOptionValue) {
          variant = that.variants.find((variant) => variant.price === giftCardDetails.amount && variant.option2 === cardDesignOptionValue);
        }
        if(!variant) {
          variant = that.variants.find((variant) => variant.price === giftCardDetails.amount);
        }

        // Make sure the correct variant is selected in the product page
        jQuery('select[id="gift-amount"]').val(variant.variation['gift-amount']).trigger('change');

        // Populate the hidden fields in the product form
        let productForm = document.querySelector("form[data-product_id='" + that.PRODUCT_ID + "']");
        let cardDesignIdInput = productForm.querySelector("input[id='loopz_card_design_id']");
        cardDesignIdInput.value = giftCardDetails.cardDesignId;
        let senderNameInput = productForm.querySelector("input[id='loopz_sender_name']");
        senderNameInput.value = giftCardDetails.senderName;
        let senderEmailInput = productForm.querySelector("input[id='loopz_sender_email']");
        senderEmailInput.value = giftCardDetails.senderEmail;
        let sendToSenderInput = productForm.querySelector("input[id='loopz_send_to_sender']");
        sendToSenderInput.value = giftCardDetails.sendToSender;
        let recipientNameInput = productForm.querySelector("input[id='loopz_recipient_name']");
        recipientNameInput.value = giftCardDetails.recipientName;
        let recipientEmailInput = productForm.querySelector("input[id='loopz_recipient_email']");
        recipientEmailInput.value = giftCardDetails.recipientEmail;
        let messageInput = productForm.querySelector("input[id='loopz_message']");
        messageInput.value = giftCardDetails.message;
        let deliveryInput = productForm.querySelector("input[id='loopz_delivery']");
        deliveryInput.value = giftCardDetails.deliveryTimeType;

        if (giftCardDetails.deliveryTimeType === 'FUTURE' && giftCardDetails.deliveryDateTime) {
          const options = {
            day: 'numeric',
            month: 'short',
            year: 'numeric'
          }
          const deliveryDateTime = new Date(Date.parse(giftCardDetails.deliveryDateTime));
          const formatter = new Intl.DateTimeFormat(that.locale, options);
          const offsetMinutes = deliveryDateTime.getTimezoneOffset(); // Local offset in minutes
          const offsetHours = Math.abs(Math.floor(offsetMinutes / 60)).toString().padStart(2, '0');
          const offsetMins = Math.abs(offsetMinutes % 60).toString().padStart(2, '0');
          const offsetSign = offsetMinutes <= 0 ? '+' : '-'; // Positive if ahead of UTC
          const offset = `${offsetSign}${offsetHours}:${offsetMins}`;
          let deliveryTimeInput = productForm.querySelector("input[id='loopz_delivery_time']");
          const deliveryTimeValue = `${formatter.format(deliveryDateTime)} - ${deliveryDateTime.getHours().toString().padStart(2, '0')}:${deliveryDateTime.getMinutes().toString().padStart(2, '0')}${offset}`;
          deliveryTimeInput.value = deliveryTimeValue;

          let deliveryTimeIsoInput = productForm.querySelector("input[id='loopz_delivery_time_iso']");
          deliveryTimeIsoInput.value = giftCardDetails.deliveryDateTime;
        }
        productForm.submit();
      }
      if(event.data === 'ready') {
        // checkout is ready, post message to checkout to initialize
        that.initCheckout();
      }
    });
  },

  getPresetAmounts: function() {
    return Array.from(new Set(this.variants.map((variant) => variant.price)));
  },

  reloadPopupContent: function(){
    if(this.popup && this.popup.iframeEl) {
      this.popup.iframeEl.src = this.buildCheckoutUrl();
    }
  },

  closePopup: function() {
    if (this.popup && this.popup.overlayEl) {
      this.popup.overlayEl.hidden = true;
      document.onkeydown = null;
    }
  },

  initCheckout: function() {
    let giftAmount = null;
    let cardDesignId = null;

    const variantId = this.resolveSelectedVariantId();
    if (variantId) {
      const variant = this.variants.find(variant => variant.id === variantId);
      if (variant) {
        giftAmount = variant.price;
        if(variant.cardDesignId) {
          const cardDesignVariantOption = Object.entries(this.VARIANT_OPTION_CARD_DESIGNS).find(cardDesignVariantOption => cardDesignVariantOption.length === 2 && cardDesignVariantOption[1] === variant.cardDesignId);
          if(cardDesignVariantOption) {
            cardDesignId = cardDesignVariantOption[0];
          }
        }
      }
    }

    if(!giftAmount) {
      let giftAmountEl = null;
      for (let i = 0; i < this.DEFAULT_AMOUNT_SELECTORS.length; i++) {
        giftAmountEl = document.querySelector(this.DEFAULT_AMOUNT_SELECTORS[i]);
        if(giftAmountEl != null) {
          break;
        }
      }

      if(giftAmountEl && giftAmountEl.value) {
        giftAmount = parseInt(giftAmountEl.value.replace(/\D/g,'')) * 100;
      }
    }

    let presetAmounts = this.getPresetAmounts();
    if(!giftAmount) {
      giftAmount = presetAmounts[0];
    }

    this.popup.iframeEl.contentWindow.postMessage({
      shopifySettings :{
        buttonLabel: this.getLocalizedString(this.locale, 'ADD_TO_CART'),
        selectedAmount: giftAmount,
        selectedCardDesignId: cardDesignId,
        presetAmounts: presetAmounts
      }
    }, '*');
  },

  resolveSelectedVariantId: function() {
    return this.selectedVariant ? this.selectedVariant.variation_id : null;
  },

  updateCartUI: function(cart) {
    if (this.UPDATE_CART_JS) {
      try {
        let customUpdateCartUIFn = new Function('cart', this.UPDATE_CART_JS);
        return customUpdateCartUIFn(cart);
      } catch(e){
        console.error("Error updating cart UI:", e);
      }
    }
    return this.resolveThemeFunction('updateCartUI').call(this);
  },

  resolveThemeFunction(functionName) {
    const theme = this.resolveTheme(this.themeName);
    return theme[functionName] ? theme[functionName] : this.themes.generic[functionName];
  },

  resolveTheme() {
    if( this.themes[this.themeName]) {
      return this.themes[this.themeName];
    }
    const themeNames = Object.keys(this.themes);
    if(themeNames && themeNames.length > 0) {
      for (var i = 0; i < themeNames.length; i++) {
        const themeName = themeNames[i];
        if(this.themeName.startsWith(themeName) || this.themeName.includes(themeName)) {
          return this.themes[themeName];
        }
      }
    }
    return this.themes.generic;
  },

  themes: {
    generic: {
      updateCartUI: function() {
        if (this.UPDATE_CART_JS) {
          try {
            const customUpdateCartUIFn = new Function(this.UPDATE_CART_JS);
            customUpdateCartUIFn();
          } catch(e){}
        } else {
          // attempt to rerender the header containing the cart icon
          const sectionHeader = document.querySelector('.section-header');

          if(sectionHeader) {
            fetch('?sections=header', {
              method: 'GET',
              headers: {
                'Content-Type': 'application/json'
              }
            }).then(response => {
              if(response) {
                response.json().then((section) => {
                  sectionHeader.outerHTML = section.header;
                })
              }
            });
          }

        }
      }
    },
    "Modular": {
      updateCartUI: function() {
        if (window.cart && window.cart.openCartDrawer) {
          window.cart.openCartDrawer();
        }
      }
    },
    "Prestige": {
      updateCartUI: function() {
        document.dispatchEvent(new CustomEvent("product:added", {detail:{quantity:1}}))
      }
    }
  }
}
LoopzGiftCardButton.init();
