jQuery(function($) {
    const connectContainer = $('#loopz-connect-container');
    const connectButton = $('#loopz-connect-button');
    const connectSpinner = connectContainer.find('.spinner');
    const connectMessage = connectContainer.find('.loopz-status-message');

    const dashboardContainer = $('#loopz-dashboard-container');
    const dashboardButton = $('#loopz-dashboard-button');
    const dashboardSpinner = connectContainer.find('.spinner');
    const dashboardMessage = connectContainer.find('.loopz-status-message');

    connectButton.on('click', function(e) {
        e.preventDefault();
        connectSpinner.addClass('is-active');
        connectMessage.empty();

        // First check existing connection
        $.post(ajaxurl, {
            action: 'loopz_check_connection',
            nonce: loopz_admin.nonce
        }).then(response => {
            if(response.success) {
                location.reload(); 
            } else {
                // Start new auth flow
                return $.post(ajaxurl, {
                    action: 'loopz_start_auth',
                    nonce: loopz_admin.nonce
                });
            }
        }).then(response => {
            if(response.success) {
                window.open(response.data.url, '_blank');
                pollConnectionStatus();
            } else {
                showError(response.data.message);
            }
        }).fail(showError).always(() => connectSpinner.removeClass('is-active'));
    });

    dashboardButton.on('click', function(e) {
        e.preventDefault();
        dashboardSpinner.addClass('is-active');
        dashboardMessage.empty();

        // First check existing connection
        // Start new auth flow
        $.post(ajaxurl, {
            action: 'loopz_open_dashboard',
            nonce: loopz_admin.nonce
        }).then(response => {
            if(response.success) {
                window.open(response.data.url, '_blank');
            } else {
                showError(response.data.message);
            }
        }).fail(showError).always(() => dashboardSpinner.removeClass('is-active'));
    });

    function pollConnectionStatus() {
        const poll = () => $.post(ajaxurl, {
            action: 'loopz_check_connection',
            nonce: loopz_admin.nonce
        }).then(response => {
            if(response.success) location.reload();
        });

        const interval = setInterval(poll, 3000);
        setTimeout(() => clearInterval(interval), 120000);
    }

    function showError(message) {
        connectMessage.html(`<div class="notice notice-error">${message}</div>`);
    }
});