<?php
/**
 * Hooks to show gift card details on the Customer order screen
 */

add_action('woocommerce_order_item_meta_end', function ($item_id, $item, $order, $plain_text) {
    // Get all metadata for the line item
    $meta_data = $item->get_meta_data();

    $loopz_metadata = [];

    foreach($meta_data as $key => $meta){
        if(strpos($meta->key, '_loopz') !== false || $meta->key === LOOPZ_META_DATA_KEY_GIFT_AMOUNT) {
            $meta_line_item = $meta_data[$key];
            $loopz_metadata[$meta_line_item->key] = $meta_line_item->value;
        }
    }

    $gift_amount = null;
    $recipient = null;
    $sender = null;
    $send_to_sender = false;
    $delivery = null;
    $message = null;

    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_RECIPIENT_NAME])) {
        $recipient = $loopz_metadata['_'.LOOPZ_META_DATA_KEY_RECIPIENT_NAME];
    }
    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_RECIPIENT_EMAIL])) {
        if(isset($recipient)) {
            $recipient .= ' - ' . $loopz_metadata['_'.LOOPZ_META_DATA_KEY_RECIPIENT_EMAIL];
        } else {
            $recipient = $loopz_metadata['_'.LOOPZ_META_DATA_KEY_RECIPIENT_EMAIL];
        }
    }
    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_SENDER_NAME])) {
        $sender = $loopz_metadata['_'.LOOPZ_META_DATA_KEY_SENDER_NAME];
    }
    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_SENDER_EMAIL])) {
        if(isset($sender)) {
            $sender .= ' - ' . $loopz_metadata['_'.LOOPZ_META_DATA_KEY_SENDER_EMAIL];
        } else {
            $sender = $loopz_metadata['_'.LOOPZ_META_DATA_KEY_SENDER_EMAIL];
        }
    }
    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_SEND_TO_SENDER])) {
        $send_to_sender = $loopz_metadata['_'.LOOPZ_META_DATA_KEY_SEND_TO_SENDER] === 'true';
    }
    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_DELIVERY])) {
        if($loopz_metadata['_'.LOOPZ_META_DATA_KEY_DELIVERY] === 'INSTANT') {
            $delivery = __('Instant', 'loopz-gift-cards');
        } else if ($loopz_metadata['_'.LOOPZ_META_DATA_KEY_DELIVERY] === 'FUTURE' && isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_DELIVERY_TIME_ISO])){
            $delivery_time = new DateTime($loopz_metadata['_'.LOOPZ_META_DATA_KEY_DELIVERY_TIME_ISO]);
            $formatted_delivery_time = wp_date(get_option('date_format') . ' ' . get_option('time_format'), $delivery_time->getTimestamp(), $delivery_time->getTimezone());
            $delivery = __('Scheduled for ', 'loopz-gift-cards').$formatted_delivery_time;
        }
    }
    if(isset($loopz_metadata['_'.LOOPZ_META_DATA_KEY_MESSAGE])) {
        $message = $loopz_metadata['_'.LOOPZ_META_DATA_KEY_MESSAGE];
    }

    if(isset($gift_amount)) {
        loopz_render_customer_order_line_item_meta_field(__('Gift amount', 'loopz-gift-cards'), $gift_amount, $plain_text);
    }
    if(isset($recipient)) {
        loopz_render_customer_order_line_item_meta_field(__('Recipient', 'loopz-gift-cards'), $recipient, $plain_text);
    }
    if(isset($sender)) {
        loopz_render_customer_order_line_item_meta_field(__('Sender', 'loopz-gift-cards'), $sender, $plain_text);
    }
    if(isset($delivery)) {
        loopz_render_customer_order_line_item_meta_field(__('Delivery', 'loopz-gift-cards'), $delivery, $plain_text);
    }
    if(isset($message)) {
        loopz_render_customer_order_line_item_meta_field(__('Message', 'loopz-gift-cards'), $message, $plain_text);
    }
}, 10, 4);

function loopz_render_customer_order_line_item_meta_field($label, $value, $plain_text) {
    if ($plain_text) {
        // Plain text output (for emails)
        echo esc_html($label) . ': ' . esc_html($value) . "\n";
    } else {
        // HTML output (for View Order page)
        echo '<div class="order-item-meta"><strong>' . esc_html($label) . ':</strong> ' . esc_html($value) . '</div>';
    }
}