<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function loopz_register_settings_page() {
    add_submenu_page(
        'woocommerce',
        'Loopz Gift Card Settings',
        'Loopz Gift Cards',
        'manage_options',
        'loopz-gift-cards-settings',
        'loopz_render_settings_page'
    );
}
add_action( 'admin_menu', 'loopz_register_settings_page' );

function loopz_render_settings_page() {
    echo '<div id="loopz-settings-root"></div>';
}

function loopz_enqueue_settings_assets( $hook ) {
    if ( $hook !== 'woocommerce_page_loopz-gift-cards-settings' ) {
        return;
    }
    $asset_path = plugins_url( '../build/loopz-settings.js', __FILE__ );
    $asset_file = plugin_dir_path( __FILE__ ) . '../build/loopz-settings.asset.php';
    $asset = include $asset_file;

    wp_enqueue_script(
        'loopz-settings-js',
        $asset_path,
        $asset['dependencies'],
        $asset['version'],
        true
    );
    wp_enqueue_style( 'wp-components' );
    wp_enqueue_style(
        'loopz-settings',
        plugins_url( '../assets/css/loopz-settings.css', __FILE__ ),
        array(),
        filemtime( plugin_dir_path( __FILE__ ) . '../assets/css/loopz-settings.css')
    );

    wp_set_script_translations('loopz-settings-js', 'loopz-gift-cards');

    // Expose settings to JS
    $redemption_enabled = loopz_preferences::get_redemption_enabled() ? true : false;
    $apply_to_shipping = loopz_preferences::get_woocommerce_apply_to_shipping() ? true : false;
    $apply_to_taxes = loopz_preferences::get_woocommerce_apply_to_taxes() ? true : false;
    $redeem_for_gift_card_order = loopz_preferences::get_redeem_for_gift_card_order() ? true : false;
    $connected = loopz_preferences::is_connected() ? true : false;
    $program_id = loopz_preferences::get_program_id();
    $merchant_id = loopz_preferences::get_merchant_id();
    $product_id = loopz_preferences::get_product_id();
    $product_permalink = $product_id ? get_permalink($product_id) : '';
    $dashboard_login_url = null;
    $auth_token = loopz_api::get_auth_token();
    if(!empty($program_id) && !empty($auth_token)) {
        $dashboard_login_url = LOOPZ_API_BASE_URI . '/woocommerce/programs/' . urlencode($program_id) . '/dashboard-link?shopDomain=' . urlencode(get_site_url()) . '&token=' . urlencode($auth_token);
    }
    wp_localize_script( 'loopz-settings-js', 'loopzSettings', array(
        'redemptionEnabled' => $redemption_enabled,
        'applyToShipping' => $apply_to_shipping,
        'applyToTaxes' => $apply_to_taxes,
        'redeemForGiftCardOrder' => $redeem_for_gift_card_order,
        'programId' => $program_id,
        'merchantId' => $merchant_id,
        'connected' => $connected,
        'dashboardLoginUrl' => $dashboard_login_url,
        'productId' => $product_id,
        'productPermalink' => $product_permalink,
        'locale' => str_replace('_', '-', get_locale()),
        'nonce' => wp_create_nonce('loopz-settings'),
        'localizedStrings' => array (
            'anonymous' => __("Anonymous", 'loopz-gift-cards'),
            'view_details' => __("View Details", 'loopz-gift-cards'),
            'gift_cards' => __('Gift cards', 'loopz-gift-cards'),
            'view_all_gift_cards' => __('View All Gift Cards', 'loopz-gift-cards'),
            'card' => __('Card', 'loopz-gift-cards'),
            'recipient' => __('Recipient', 'loopz-gift-cards'),
            'balance' => __('Balance', 'loopz-gift-cards'),
            'activated_on' => __('Activated On', 'loopz-gift-cards'),
            'settings' => __('Settings', 'loopz-gift-cards'),
            'gift_card_redemption_settings' => __('Gift card redemption settings', 'loopz-gift-cards'),
            'control_gift_card_balance' => __('Control how a gift card balance is applied to an order', 'loopz-gift-cards'),
            'gift_card_redemption' => __('Gift card redemption', 'loopz-gift-cards'),
            'enabled' => __('enabled', 'loopz-gift-cards'),
            'disabled' => __('disabled', 'loopz-gift-cards'),
            'enables_gift_card_redemption' => __('Enables gift card redemption in the cart and checkout pages.', 'loopz-gift-cards'),
            'apply_to_shipping' => __('Apply to Shipping', 'loopz-gift-cards'),
            'allow_shipping_application' => __('Allow a gift card balance to apply to an order\'s shipping amount.', 'loopz-gift-cards'),
            'apply_to_taxes' => __('Apply to Taxes', 'loopz-gift-cards'),
            'allow_tax_application' => __('Allow a gift card balance to apply to an order\'s tax amount.', 'loopz-gift-cards'),
            'redeem_for_gift_card_orders' => __('Redeem for Gift Card Orders', 'loopz-gift-cards'),
            'allow_gift_card_redemption' => __('Allow a gift card to be redeemed when other gift cards are being purchased.', 'loopz-gift-cards'),
            'save_changes' => __('Save changes', 'loopz-gift-cards'),
            'settings_saved' => __('Settings saved.', 'loopz-gift-cards'),
            'error_saving_settings' => __('Error saving settings.', 'loopz-gift-cards'),
            'error_connecting_to_loopz' => __('Error connecting to Loopz.', 'loopz-gift-cards'),
            'disconnected_from_loopz' => __('Disconnected from Loopz.', 'loopz-gift-cards'),
            'error_disconnecting_from_loopz' => __('Error disconnecting from Loopz.', 'loopz-gift-cards'),
            'logging_into_dashboard' => __('Logging into your Loopz Gift Cards dashboard...', 'loopz-gift-cards'),
            'open_dashboard' => __('Open Dashboard', 'loopz-gift-cards'),
            'error_retrieving_gift_cards' => __('Error occurred retrieving gift cards.', 'loopz-gift-cards'),
            'account_status' => __('Account status', 'loopz-gift-cards'),
            'connected' => __('Connected', 'loopz-gift-cards'),
            'loopz_gift_cards' => __('Loopz Gift Cards', 'loopz-gift-cards'),
            'connect_store_description' => __('Connect your store to Loopz to sell & redeem gift cards on your store.', 'loopz-gift-cards'),
            'connect' => __('Connect', 'loopz-gift-cards'),
            'disconnect_confirmation' => __('Are you sure you want to disconnect Loopz Gift Cards from your store? Gift cards won\'t be able to be sold or redeemed. Your subscription will also be canceled.', 'loopz-gift-cards'),

        )
    ) );
}
add_action( 'admin_enqueue_scripts', 'loopz_enqueue_settings_assets' );

function ajax_connect_account() {
    try {
        // Check if the site is already connected to loopz
        $api_response = loopz_api::get_config();
        if($api_response->success) {
            loopz_preferences::set_connection_config($api_response->body);
            wp_send_json_success(['url' => get_site_url().'/wp-admin/admin.php?page=loopz-gift-cards-settings&tab=settings']);
        } else {
            $shop_domain = get_site_url();
            $response = wp_remote_post(LOOPZ_API_BASE_URI.'/external-authentication/authorize', [
                'headers' => ['Content-Type' => 'application/json'],
                'body' => json_encode([
                    'type' => 'WOOCOMMERCE',
                    'state' => ['action' => 'WINDOW'],
                    'shopDomain' => $shop_domain
                ]),
                'timeout' => 45
            ]);

            $status = wp_remote_retrieve_response_code($response);
            $body = json_decode(wp_remote_retrieve_body($response), true);

            if($status === 200 && isset($body['init']['authorizeUrl'])) {
                wp_send_json_success(['url' => $body['init']['authorizeUrl']]);
            }

            wp_send_json_error(['message' => 'Failed to start authentication']);
        }
    } catch (Exception $e) {
        wp_send_json_error(['message' => $e->getMessage()]);
    }
}
add_action('wp_ajax_loopz_connect_account', 'ajax_connect_account');

function ajax_disconnect_account() {
    try {
        loopz_api::offboard();
        loopz_preferences::disconnect();
        wp_send_json_success(['disconnected' => true]);
    } catch (Exception $e) {
        wp_send_json_error(['message' => $e->getMessage()]);
    }
}

add_action('wp_ajax_loopz_disconnect_account', 'ajax_disconnect_account');

function ajax_open_dashboard() {
    try {
        // Check if the site is connected to loopz
        if (!loopz_preferences::is_connected()) {
            wp_send_json_error(['message' => 'Store is not connected to Loopz']);
        }

        $response = loopz_api::get_dashboard_login_link();

        if($response == false) {
            wp_send_json_error(['message' => 'Unable to get dashboard login link']);
        }

        // Return the dashboard URL in JSON response
        wp_send_json_success(['url' => $response]);
    } catch (Exception $e) {
        wp_send_json_error(['message' => $e->getMessage()]);
    }
}
add_action('wp_ajax_loopz_open_dashboard', 'ajax_open_dashboard');

// AJAX handler to save settings
add_action('wp_ajax_loopz_save_settings', function() {
    if ( ! current_user_can('manage_options') ) {
        wp_send_json_error(['message' => 'Unauthorized'], 403);
    }
    if(!isset($_POST['nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nonce'])), 'loopz-settings')) {
        wp_send_json_error(['message' => 'Unauthorized'], 403);
    }

    $redemption_enabled = isset($_POST['redemptionEnabled']) ? sanitize_text_field(wp_unslash($_POST['redemptionEnabled'])) : true;
    $apply_to_shipping = isset($_POST['applyToShipping']) ? sanitize_text_field(wp_unslash($_POST['applyToShipping'])) : false;
    $apply_to_taxes = isset($_POST['applyToTaxes']) ? sanitize_text_field(wp_unslash($_POST['applyToTaxes'])) : false;
    $redeem_for_gift_card_order = isset($_POST['redeemForGiftCardOrder']) ? sanitize_text_field(wp_unslash($_POST['redeemForGiftCardOrder'])) : false;

    if ( ! class_exists('loopz_preferences') ) {
        require_once plugin_dir_path(__FILE__) . 'loopz-preferences-class.php';
    }
    loopz_preferences::set_woocommerce_apply_to_shipping($apply_to_shipping);
    loopz_preferences::set_woocommerce_apply_to_taxes($apply_to_taxes);
    loopz_preferences::set_redeem_for_gift_card_order($redeem_for_gift_card_order);
    loopz_preferences::set_redemption_enabled($redemption_enabled);

    wp_send_json_success(['message' => 'Settings saved']);
});

// AJAX handler to fetch additional account settings (empty implementation for now)
add_action('wp_ajax_loopz_get_additional_account_settings', function() {
    wp_send_json_success([]);
});

// AJAX handler to fetch gift cards for settings page
add_action('wp_ajax_loopz_list_gift_cards', function() {
    wp_send_json_success(loopz_api::list_gift_cards());
});



