<?php

/**
 * Stores and retrieves any data the plugin needs.
 */
class loopz_preferences
{
    const WOO_MODE_DISCOUNT_COUPONS = 'DISCOUNT_COUPONS';
    const WOO_MODE_API = 'API';

    public static function has_api_key() {
        if (self::get_api_key()) {
            return true;
        }

        return false;
    }
	public static function has_valid_token() {
		if (self::get_valid_token()) {
			return true;
		}

		return false;
	}

    public static function get_version() {
        return self::get_option( "version" );
    }
    public static function set_version( $value ) {
        return self::update_option( "version", $value );
    }

    public static function get_merchant_id() {
        return self::get_option( "merchant_id" );
    }

    public static function set_merchant_id( $value ) {
        return self::update_option( "merchant_id", $value );
    }

    public static function get_program_id() {
        return self::get_option( "program_id" );
    }

    public static function set_program_id( $value ) {
        return self::update_option( "program_id", $value );
    }

    public static function get_product_id() {
        return self::get_option( "product_id" );
    }

    public static function set_product_id( $value ) {
        return self::update_option( "product_id", $value );
    }

    public static function get_product_script_url() {
        return self::get_option( "product_script_url" );
    }

    public static function set_product_script_url( $value ) {
        return self::update_option( "product_script_url", $value );
    }

    public static function get_embed_on_out_of_stock() {
        return self::get_bool_option( "embed_on_out_of_stock" );
    }

    public static function set_embed_on_out_of_stock( $value ) {
        return self::update_bool_option( "embed_on_out_of_stock", $value );
    }

    public static function get_open_cart_page() {
        return self::get_option( "open_cart_page" );
    }

    public static function set_open_cart_page( $value ) {
        return self::update_option( "open_cart_page", $value );
    }

    public static function get_open_popup_on_visit() {
        return self::get_option( "open_popup_on_visit" );
    }

    public static function set_open_popup_on_visit( $value ) {
        return self::update_option( "open_popup_on_visit", $value );
    }

    public static function get_program_currency() {
        return self::get_option( "program_currency" );
    }

    public static function set_program_currency( $value ) {
        return self::update_option( "program_currency", $value );
    }

    public static function get_api_key() {
        return self::get_option( "api_key" );
    }
    public static function set_api_key( $value ) {
        return self::update_option( "api_key", $value );
    }

    public static function get_woocommerce_enabled() {
        return self::get_bool_option( "woocommerce_enabled" );
    }
    public static function set_woocommerce_enabled( $value ) {
        return self::update_bool_option( "woocommerce_enabled", $value );
    }

    public static function get_woocommerce_apply_to_shipping() {
        return self::get_bool_option( "woocommerce_apply_to_shipping" );
    }
    public static function set_woocommerce_apply_to_shipping( $value ) {
        return self::update_bool_option( "woocommerce_apply_to_shipping", $value );
    }

    public static function get_woocommerce_apply_to_taxes() {
        return self::get_bool_option( "woocommerce_apply_to_taxes" );
    }
    public static function set_woocommerce_apply_to_taxes( $value ) {
        return self::update_bool_option( "woocommerce_apply_to_taxes", $value );
    }

    public static function get_redeem_for_gift_card_order() {
        return self::get_bool_option( "redeem_for_gift_card_order" );
    }
    public static function set_redeem_for_gift_card_order( $value ) {
        return self::update_bool_option( "redeem_for_gift_card_order", $value );
    }

    public static function get_redemption_enabled() {
        return self::get_bool_option( "redemption_enabled" );
    }
    public static function set_redemption_enabled( $value ) {
        return self::update_bool_option( "redemption_enabled", $value );
    }

    public static function get_woocommerce_test_mode() {
        return current_user_can('administrator') && isset($_COOKIE["loopz_test_mode"]) && $_COOKIE["loopz_test_mode"] == "test";
    }

    public static function get_woocommerce_diagnostics_mode() {
        return isset($_COOKIE["loopz_diagnostics_mode"]) && $_COOKIE["loopz_diagnostics_mode"] == "on";
    }

    public static function disconnect() {
        delete_option( "loopz_merchant_id" );
        delete_option( "loopz_program_id" );
        delete_option( "loopz_product_id" );
        delete_option( "loopz_product_id" );
        delete_option( "loopz_product_script_url" );
        delete_option( "loopz_embed_on_out_of_stock" );
        delete_option( "loopz_open_cart_page" );
        delete_option( "loopz_open_popup_on_visit" );
        delete_option( "loopz_version" );
        delete_option( "loopz_connected" );
        delete_option( "loopz_woocommerce_enabled" );
        delete_option( "loopz_woocommerce_apply_to_shipping" );
        delete_option( "loopz_woocommerce_apply_to_taxes" );
        delete_option( "loopz_redeem_for_gift_card_order" );
        delete_option( "loopz_redemption_enabled" );

    }

    private static function get_option( $option, $default = false ) {
        $option_value = get_option( "loopz_$option", $default );
        return $option_value;
    }
    private static function update_option( $option, $value ) {
        return update_option( "loopz_$option", $value );
    }

    private static function get_bool_option( $option, $default = false ) {
        $option_value = get_option( "loopz_$option", $default );
        if($option_value === 'yes' || $option_value === '1' || $option_value === 1 || $option_value === 'true') {
            $option_value = true;
        } else if($option_value === 'no' || $option_value === '0' || $option_value === 0 || $option_value === 'false') {
            $option_value = false;
        }
        return $option_value;
    }
    private static function update_bool_option( $option, $value ) {
        if($value === 'yes' || $value === '1' || $value === 1 || $value === 'true') {
            $value = true;
        }
        else if($value === 'no' || $value === '0' || $value === 0 || $value === 'false') {
            $value = false;
        }
        return update_option( "loopz_$option", $value );
    }
	// Add connection config storage
	public static function set_connection_config($config) {
        if(isset($config['productId'])) {
            self::set_product_id($config['productId']);
        }
        if(isset($config['productScriptUrl'])) {
            self::set_product_script_url($config['productScriptUrl']);
        }
        if(isset($config['embedOnOutOfStock'])) {
            self::set_embed_on_out_of_stock($config['embedOnOutOfStock']);
        }
        if(isset($config['openCartPage'])) {
            self::set_open_cart_page($config['openCartPage']);
        }
        if(isset($config['openPopupOnVisit'])) {
            self::set_open_popup_on_visit($config['openPopupOnVisit']);
        }
        self::set_program_id($config['programId']);
        self::set_merchant_id($config['merchantId']);
        self::set_woocommerce_enabled(true);
        self::set_woocommerce_apply_to_shipping(true);
        self::set_woocommerce_apply_to_taxes(true);
        self::set_redemption_enabled(true);
        self::set_redeem_for_gift_card_order(false);
		// Set other necessary preferences
		update_option('loopz_connected', true);
	}

	public static function is_connected() {
		return get_option('loopz_connected', false);
	}

	// Stores the confirmed valid token in WP option.
	public static function set_valid_token( $token ) {
		update_option( 'loopz_valid_token', $token );
	}

	// Retrieves the currently stored valid token.
	public static function get_valid_token() {
		return get_option( 'loopz_valid_token', '' );
	}
}