/**
 * External dependencies
 */
import { registerBlockType } from '@wordpress/blocks';
import { G} from '@wordpress/components';
import { Icon } from '@wordpress/icons';

/**
 * Internal dependencies
 */
import { Edit, Save } from './edit';
import metadata from './block.json';
import {Path, SVG} from "@wordpress/components";
import React from "react";

registerBlockType(metadata, {
	icon: {
		src: <Icon icon={
			<SVG viewBox="0 0 527 391" xmlns="http://www.w3.org/2000/svg">
				<G id="Artboard" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round"
				   stroke-linejoin="round">
					<G id="iconfinder_aami7-58_641993" transform="translate(10.000000, 10.000000)" stroke="#303F9F"
					   stroke-width="20">
						<Path
							d="M256.688889,30.0909091 L472.866667,30.0909091 C492.208889,30.0909091 507,44.8636364 507,64.1818182 L507,336.909091 C507,356.227273 492.208889,371 472.866667,371 L63.2666667,371 C43.9244444,371 29.1333333,356.227273 29.1333333,336.909091 L29.1333333,246"
							id="Shape"/>
						<Path
							d="M203.213333,78.9545455 C185.008889,97.1363636 114.466667,102.818182 114.466667,102.818182 C114.466667,102.818182 121.293333,32.3636364 138.36,14.1818182 C155.426667,-4 185.008889,-4 203.213333,14.1818182 C221.417778,32.3636364 221.417778,60.7727273 203.213333,78.9545455 Z"
							id="Shape"/>
						<Path
							d="M139.497778,202.818182 C121.293333,184.636364 115.604444,114.181818 115.604444,114.181818 C115.604444,114.181818 186.146667,121 204.351111,138.045455 C222.555556,155.090909 222.555556,184.636364 204.351111,202.818182 C186.146667,221 156.564444,221 139.497778,202.818182 Z"
							id="Shape"/>
						<Path
							d="M14.3422222,139.181818 C32.5466667,121 103.088889,115.318182 103.088889,115.318182 C103.088889,115.318182 96.2622222,185.772727 79.1955556,203.954545 C60.9911111,222.136364 32.5466667,222.136364 14.3422222,203.954545 C-2.72444444,185.772727 -2.72444444,156.227273 14.3422222,139.181818 Z"
							id="Shape"/>
						<Path
							d="M79.1955556,14.1818182 C97.4,32.3636364 103.088889,102.818182 103.088889,102.818182 C103.088889,102.818182 32.5466667,96 14.3422222,78.9545455 C-3.86222222,61.9090909 -3.86222222,32.3636364 14.3422222,14.1818182 C32.5466667,-4 60.9911111,-4 79.1955556,14.1818182 Z"
							id="Shape"/>
						<Path d="M108.777778,234.636364 L108.777778,371" id="Shape"/>
						<Path d="M222.555556,109.636364 L507,109.636364" id="Shape"/>
						<Path
							d="M272.617778,243.727273 C268.066667,235.772727 258.964444,231.227273 249.862222,231.227273 C233.933333,231.227273 222.555556,243.727273 222.555556,259.636364 L222.555556,298.272727 C222.555556,314.181818 236.208889,326.681818 252.137778,326.681818 C263.515556,326.681818 279.444444,321 279.444444,309.636364 L279.444444,291.454545 L256.688889,291.454545"
							id="Shape"/>
						<Path d="M461.488889,234.636364 L415.977778,234.636364" id="Shape"/>
						<Path d="M438.733333,234.636364 L438.733333,325.545455" id="Shape"/>
						<Path id="Shape" d="M347.7111 325.5455L347.7111 234.6364L381.8444 234.6364"/>
						<Path d="M347.711111,280.090909 L381.844444,280.090909" id="Shape"/>
						<Path d="M313.577778,234.636364 L313.577778,325.545455" id="Shape"/>
					</G>
				</G>
			</SVG>}/>,
	},
	edit: Edit,
	save: Save,
});
