// Added to the Order Admin screen to add the refund as store credit feature in the refund actions section
window.LoopzRefundOrderStoreCredit = window.LoopzRefundOrderStoreCredit || {
    REFUND_MANUAL_BUTTON_SELECTOR: '.refund-actions .do-manual-refund',
    init: function() {
        const localizedStrings = window.LoopzRefundOrderStoreCreditSettings.localizedStrings;
        var refundManualButton = document.querySelector(this.REFUND_MANUAL_BUTTON_SELECTOR);
        if(!refundManualButton) {
            return;
        }

        var refundStoreCreditButton = refundManualButton.cloneNode(true);
        refundStoreCreditButton.classList.remove('tips');
        refundStoreCreditButton.classList.remove('do-manual-refund');
        refundStoreCreditButton.lastChild.textContent = ' ' + localizedStrings.as_store_credit;
        refundStoreCreditButton.setAttribute('data-tip', localizedStrings.button_tool_tip);

        refundStoreCreditButton.onclick = this.refund;
        jQuery(refundStoreCreditButton).tipTip({
            'attribute': 'data-tip',
            'fadeIn': 50,
            'fadeOut': 50,
            'delay': 200,
            'keepAlive': true
        });

        refundManualButton.after(refundStoreCreditButton);
    },

    refund: function() {
        var refund_amount   = jQuery( 'input#refund_amount' ).val();
        var refund_reason   = jQuery( 'input#refund_reason' ).val();
        var refunded_amount = jQuery( 'input#refunded_amount' ).val();

        // Get line item refunds
        var line_item_qtys       = {};
        var line_item_totals     = {};
        var line_item_tax_totals = {};

        jQuery( '.refund input.refund_order_item_qty' ).each(function( index, item ) {
            if ( jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ) {
                if ( item.value ) {
                    line_item_qtys[ jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ] = item.value;
                }
            }
        });

        jQuery( '.refund input.refund_line_total' ).each(function( index, item ) {
            if ( jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ) {
                line_item_totals[ jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ] = accounting.unformat(
                    item.value,
                    woocommerce_admin.mon_decimal_point
                );
            }
        });

        jQuery( '.refund input.refund_line_tax' ).each(function( index, item ) {
            if ( jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ) {
                var tax_id = jQuery( item ).data( 'tax_id' );

                if ( ! line_item_tax_totals[ jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ] ) {
                    line_item_tax_totals[ jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ] = {};
                }

                line_item_tax_totals[ jQuery( item ).closest( 'tr' ).data( 'order_item_id' ) ][ tax_id ] = accounting.unformat(
                    item.value,
                    woocommerce_admin.mon_decimal_point
                );
            }
        });

        var data = {
            action                : 'loopz_process_store_credit_refund',
            order_id              : woocommerce_admin_meta_boxes.post_id,
            refund_amount         : refund_amount,
            refunded_amount       : refunded_amount,
            refund_reason         : refund_reason,
            line_item_qtys        : JSON.stringify( line_item_qtys, null, '' ),
            line_item_totals      : JSON.stringify( line_item_totals, null, '' ),
            line_item_tax_totals  : JSON.stringify( line_item_tax_totals, null, '' ),
            restock_refunded_items: jQuery( '#restock_refunded_items:checked' ).length ? 'true': 'false',
            email                 : LoopzRefundOrderStoreCreditSettings.customer_email,
            name                  : LoopzRefundOrderStoreCreditSettings.customer_name,
            nonce                 : LoopzRefundOrderStoreCreditSettings.nonce
        };

        jQuery.ajax( {
            url:     woocommerce_admin_meta_boxes.ajax_url,
            data:    data,
            type:    'POST',
            success: function( response ) {
                if ( true === response.success ) {
                    // Redirect to same page for show the refunded status
                    window.location.reload();
                } else {
                    window.alert( response.data.message );
                    wc_meta_boxes_order_items.reload_items();
                    wc_meta_boxes_order_items.unblock();
                }
            },
            complete: function() {
                window.wcTracks.recordEvent( 'order_edit_refunded', {
                    order_id: data.order_id,
                    status: jQuery( '#order_status' ).val(),
                    api_refund: false,
                    has_reason: Boolean( data.refund_reason.length ),
                    restock: 'true' === data.restock_refunded_items
                } );
            }
        } );
    }
}

LoopzRefundOrderStoreCredit.init();