import { info, caution, error, published } from '@wordpress/icons';
import PropTypes from "prop-types";

function contextBasedIcon( intent = 'default' ) {
    switch ( intent ) {
        case 'info':
            return info;
        case 'success':
            return published;
        case 'warning':
            return caution;
        case 'error':
            return error;
        default:
            return null;
    }
}

// JS-in-JS styles
const baseBadgeStyle = {
    display: 'inline-flex',
    alignItems: 'center',
    fontSize: 12,
    fontWeight: 500,
    borderRadius: 2,
    padding: '2px 8px',
    lineHeight: 1.5,
    background: '#f0f0f0',
    color: '#222',
    marginRight: '8px',

};

const iconStyle = {
    marginRight: 6,
    display: 'flex',
    alignItems: 'center',
};

const contentStyle = {
    display: 'inline-block',
};

const intentStyles = {
    success: { background: '#edfaef', color: '#005c12' },
    danger: { background: '#d63638', color: '#fff' },
    warning: { background: '#ffb900', color: '#222' },
    info: { background: '#00aadc', color: '#fff' },
};

Badge.propTypes = {
    intent: PropTypes.string,
    children: PropTypes.node,
}

function Badge({
               intent = 'default',
               children,
               ...props}) {

    const badgeStyle = {
        ...baseBadgeStyle,
        ...(intent !== 'default' && intentStyles[intent] ? intentStyles[intent] : {}),
        ...props.style,
    };

    delete props.style;

    return (
        <span
            style={badgeStyle}
            {...props}
        >
            <span style={contentStyle}>{children}</span>
        </span>
    );
}

export default Badge;